package ru.yandex.travel.hotels.extranet.extract.support

import org.springframework.batch.core.configuration.annotation.JobBuilderFactory
import org.springframework.batch.core.job.builder.JobBuilder
import org.springframework.batch.core.repository.JobRepository
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty
import org.springframework.context.annotation.Primary
import org.springframework.stereotype.Component

@Primary
@Component
@ConditionalOnProperty(
    name = ["spring.datasource.driverClassName"],
    havingValue = "org.postgresql.Driver"
)
@ConditionalOnBean(JobRepository::class, MaterializedWebViewRefresher::class)
class JobFactory(
    jobRepo: JobRepository,
    private val refresherService: MaterializedWebViewRefresher,
) : JobBuilderFactory(jobRepo) {
    override fun get(name: String): JobBuilder {
        return super.get(name).listener(refresherService)
    }
}
