package ru.yandex.travel.hotels.extranet.extract.support

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty
import org.springframework.boot.context.properties.EnableConfigurationProperties
import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import ru.yandex.travel.workflow.ha.DBMasterLockManager
import ru.yandex.travel.workflow.ha.HAManager
import ru.yandex.travel.workflow.ha.MasterLockManager
import javax.sql.DataSource

@Configuration
@EnableConfigurationProperties(
    HaConfigurationProperties::class
)
@ConditionalOnProperty("high-availability.enabled")
open class MasterLockConfiguration(
    private val properties: HaConfigurationProperties,
    private val dataSource: DataSource
) {

    @Bean
    open fun masterLockManager(): MasterLockManager {
        return DBMasterLockManager(
            dataSource,
            properties.masterLockInitialPingDelayDuration,
            properties.masterLockPingDuration,
            properties.masterPingQueryTimeoutSeconds
        )
    }

    @Bean
    open fun haManager(runner: JobScheduleRunner): HAManager {
        return HAManager(
            masterLockManager(), runner,
            properties.promoteDuration,
            properties.stopDuration,
            properties.retryAcquireMasterLockDuration
        )
    }
}
