package ru.yandex.travel.hotels.extranet.extract.support

import org.hibernate.PessimisticLockException
import org.slf4j.LoggerFactory
import org.springframework.batch.core.JobExecution
import org.springframework.batch.core.JobExecutionListener
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty
import org.springframework.stereotype.Service
import org.springframework.transaction.annotation.Transactional
import ru.yandex.travel.hotels.extranet.repository.AbstractWebViewRepo
import javax.persistence.PersistenceException

@Service
@ConditionalOnProperty(
    name = ["spring.datasource.driverClassName"],
    havingValue = "org.postgresql.Driver"
)
open class MaterializedWebViewRefresher(
    private val materializedViewRepos: Map<String, AbstractWebViewRepo>,
) : JobExecutionListener {
    private val log = LoggerFactory.getLogger(javaClass)

    override fun beforeJob(jobExecution: JobExecution) {
    }

    @Transactional
    override fun afterJob(jobExecution: JobExecution) {
        log.debug("Refreshing materialized views after ${jobExecution}: ${materializedViewRepos.keys}")
        materializedViewRepos.forEach {
            try {
                it.value.refreshMaterializedView()
                log.debug("Refreshed " + it.key)
            } catch (e: PersistenceException) {
                log.error("Failed updating " + it.key, e)
                // TODO report to solomon
            }
        }
    }
}
