package ru.yandex.travel.hotels.extranet.grpc

import io.grpc.stub.StreamObserver
import org.springframework.beans.factory.annotation.Autowired
import ru.yandex.travel.grpc.GrpcService
import ru.yandex.travel.hotels.extranet.AddAnnulationPolicyRequest
import ru.yandex.travel.hotels.extranet.AddAnnulationPolicyResponse
import ru.yandex.travel.hotels.extranet.AnnulationPoliciesServiceGrpc
import ru.yandex.travel.hotels.extranet.DeleteAnnulationPolicyRequest
import ru.yandex.travel.hotels.extranet.DeleteAnnulationPolicyResponse
import ru.yandex.travel.hotels.extranet.ListAnnulationPoliciesRequest
import ru.yandex.travel.hotels.extranet.ListAnnulationPoliciesResponse
import ru.yandex.travel.hotels.extranet.UpdateAnnulationPolicyRequest
import ru.yandex.travel.hotels.extranet.UpdateAnnulationPolicyResponse
import ru.yandex.travel.hotels.extranet.service.content.annulation.AnnulationPoliciesService
import java.io.Closeable
import java.util.UUID
import javax.persistence.EntityManagerFactory

@GrpcService(authenticateService = true, authenticateUser = true)
class AnnulationPoliciesGrpcServiceImpl @Autowired constructor(
    private val service: AnnulationPoliciesService,
    private val entityFactory: EntityManagerFactory,
) : AnnulationPoliciesServiceGrpc.AnnulationPoliciesServiceImplBase(), Closeable {

    override fun listAnnulationPolicies(
        request: ListAnnulationPoliciesRequest, responseObserver: StreamObserver<ListAnnulationPoliciesResponse>
    ) {
        entityFactory.wrapGrpc(request, responseObserver) {
            ListAnnulationPoliciesResponse.newBuilder()
                .addAllPolicies(service.list(UUID.fromString(request.organizationId))).build()
        }
    }

    override fun addAnnulationPolicy(
        request: AddAnnulationPolicyRequest, responseObserver: StreamObserver<AddAnnulationPolicyResponse>
    ) {
        entityFactory.wrapGrpc(request, responseObserver) {
            val createdPolicy = service.create(
                UUID.fromString(request.organizationId), request.name, request.rulesList
            )
            AddAnnulationPolicyResponse.newBuilder().setPolicy(createdPolicy).build()
        }
    }

    override fun deleteAnnulationPolicy(
        request: DeleteAnnulationPolicyRequest, responseObserver: StreamObserver<DeleteAnnulationPolicyResponse>
    ) {
        entityFactory.wrapGrpc(request, responseObserver) {
            service.delete(UUID.fromString(request.organizationId), request.policyId)
            DeleteAnnulationPolicyResponse.getDefaultInstance()
        }
    }

    override fun updateAnnulationPolicy(
        request: UpdateAnnulationPolicyRequest, responseObserver: StreamObserver<UpdateAnnulationPolicyResponse>
    ) {
        entityFactory.wrapGrpc(request, responseObserver) {
            val updated = service.update(
                UUID.fromString(request.organizationId),
                request.policyId,
                request.name.ifBlank { null },
                request.rulesList.ifEmpty { null }
            )
            UpdateAnnulationPolicyResponse.newBuilder().setPolicy(updated).build()
        }
    }

    override fun close() {
        entityFactory.close()
    }
}
