package ru.yandex.travel.hotels.extranet.grpc

import io.grpc.stub.StreamObserver
import org.springframework.beans.factory.annotation.Autowired
import ru.yandex.travel.grpc.GrpcService
import ru.yandex.travel.hotels.extranet.HotelsExtranetApiServiceGrpc
import ru.yandex.travel.hotels.extranet.TGetBankOrderDetailsReq
import ru.yandex.travel.hotels.extranet.TGetBankOrderDetailsRsp
import ru.yandex.travel.hotels.extranet.TGetBankOrderInfoReq
import ru.yandex.travel.hotels.extranet.TGetBankOrderInfoRsp
import ru.yandex.travel.hotels.extranet.TGetOrdersReq
import ru.yandex.travel.hotels.extranet.TGetOrdersRsp
import ru.yandex.travel.hotels.extranet.service.bankorders.BankOrdersService
import ru.yandex.travel.hotels.extranet.service.orders.OrdersService

@GrpcService(authenticateUser = true, authenticateService = true)
class ApiGrpcServiceImpl @Autowired constructor(
    private val ordersService: OrdersService,
    private val bankOrdersService: BankOrdersService,
) : HotelsExtranetApiServiceGrpc.HotelsExtranetApiServiceImplBase() {

    override fun getOrders(request: TGetOrdersReq, responseObserver: StreamObserver<TGetOrdersRsp>) {
        grpcWrapper(request, responseObserver) { ordersService.getOrders(it) }
    }

    override fun getBankOrderInfo(
        request: TGetBankOrderInfoReq,
        responseObserver: StreamObserver<TGetBankOrderInfoRsp>
    ) {
        grpcWrapper(request, responseObserver) { bankOrdersService.getBankOrders(it) }
    }

    override fun getBankOrderDetails(
        request: TGetBankOrderDetailsReq,
        responseObserver: StreamObserver<TGetBankOrderDetailsRsp>
    ) {
        grpcWrapper(request, responseObserver) { bankOrdersService.getBankOrderDetails(it) }
    }
}
