package ru.yandex.travel.hotels.extranet.grpc

import io.grpc.stub.StreamObserver
import org.springframework.beans.factory.annotation.Autowired
import ru.yandex.travel.grpc.GrpcService
import ru.yandex.travel.hotels.extranet.HotelsExtranetAuthApiServiceGrpc
import ru.yandex.travel.hotels.extranet.TApproveAuthReq
import ru.yandex.travel.hotels.extranet.TApproveAuthRsp
import ru.yandex.travel.hotels.extranet.TListApprovedReq
import ru.yandex.travel.hotels.extranet.TListApprovedRsp
import ru.yandex.travel.hotels.extranet.TRequestAuthReq
import ru.yandex.travel.hotels.extranet.TRequestAuthRsp
import ru.yandex.travel.hotels.extranet.service.hotels.HotelInfoService
import ru.yandex.travel.hotels.extranet.service.invitations.InvitationService
import javax.persistence.EntityManagerFactory

@GrpcService(authenticateUser = true, authenticateService = true)
class AuthApiGrpcServiceImpl @Autowired constructor(
    private val invitationService: InvitationService,
    private val hotelInfoService: HotelInfoService,
    private val entityFactory: EntityManagerFactory,
) : HotelsExtranetAuthApiServiceGrpc.HotelsExtranetAuthApiServiceImplBase() {

    override fun requestAuth(request: TRequestAuthReq, responseObserver: StreamObserver<TRequestAuthRsp>) {
        entityFactory.wrapGrpc(request, responseObserver) {
            invitationService.requestInvitation(it)
        }
    }

    override fun approveAuth(request: TApproveAuthReq, responseObserver: StreamObserver<TApproveAuthRsp>) {
        entityFactory.wrapGrpc(request, responseObserver) {
            invitationService.acceptInvitation(it)
        }
    }

    override fun listApproved(request: TListApprovedReq, responseObserver: StreamObserver<TListApprovedRsp>) {
        entityFactory.wrapGrpc(request, responseObserver) {
            TListApprovedRsp.newBuilder().addAllHotels(hotelInfoService.listAvailableHotels()).build()
        }
    }
}
