package ru.yandex.travel.hotels.extranet.grpc

import io.grpc.stub.StreamObserver
import org.springframework.beans.factory.annotation.Autowired
import ru.yandex.travel.grpc.GrpcService
import ru.yandex.travel.hotels.extranet.*
import ru.yandex.travel.hotels.extranet.service.roles.IdmService
import javax.persistence.EntityManagerFactory

@GrpcService(authenticateService = true)
class IdmGrpcServiceImpl @Autowired constructor(
    private val idmService: IdmService,
    private val entityFactory: EntityManagerFactory
) : HotelsExtranetIdmServiceGrpc.HotelsExtranetIdmServiceImplBase() {

    override fun rolesInfo(request: RolesInfoRequest, responseObserver: StreamObserver<RolesInfoResponse>) {
        entityFactory.wrapGrpc(request, responseObserver) {
            RolesInfoResponse.newBuilder()
                .addAllRoles(idmService.roleInfo())
                .build()
        }
    }

    override fun addRole(request: AddRoleRequest, responseObserver: StreamObserver<AddRoleResponse>) {
        entityFactory.wrapGrpc(request, responseObserver) {
            val resp = idmService.grantIdmRole(it.role, it.login, it.passportLogin)
            AddRoleResponse.newBuilder()
                .setDetails(resp)
                .build()
        }
    }

    override fun removeRole(request: RemoveRoleRequest, responseObserver: StreamObserver<RemoveRoleResponse>) {
        entityFactory.wrapGrpc(request, responseObserver) {
            val resp = idmService.removeIdmRole(it.role, it.login)
            RemoveRoleResponse.newBuilder()
                .setDetails(resp)
                .build()
        }
    }

    override fun getAllRoles(request: GetAllRolesRequest, responseObserver: StreamObserver<GetAllRolesResponse>) {
        entityFactory.wrapGrpc(request, responseObserver) {
            GetAllRolesResponse.newBuilder()
                .addAllUsers(idmService.listIdmRoles())
                .build()
        }
    }
}
