package ru.yandex.travel.hotels.extranet.grpc

import io.grpc.stub.StreamObserver
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.boot.actuate.health.HealthEndpoint
import org.springframework.boot.actuate.health.Status
import ru.yandex.travel.grpc.GrpcService
import ru.yandex.travel.hotels.extranet.PingServiceV1Grpc
import ru.yandex.travel.hotels.proto.TPingRpcReq
import ru.yandex.travel.hotels.proto.TPingRpcRsp

@GrpcService(trace = false)
class PingGrpcServiceImpl(
    @Autowired private val healthEndpoint: HealthEndpoint
) : PingServiceV1Grpc.PingServiceV1ImplBase() {
    override fun ping(request: TPingRpcReq, responseObserver: StreamObserver<TPingRpcRsp>) {
        responseObserver.onNext(
            TPingRpcRsp.newBuilder()
                .setIsReady(healthEndpoint.health().status === Status.UP)
                .build()
        )
        responseObserver.onCompleted()
    }
}
