package ru.yandex.travel.hotels.extranet.repository

import org.springframework.data.domain.PageRequest
import org.springframework.data.domain.Pageable
import org.springframework.data.jpa.repository.JpaRepository
import org.springframework.data.jpa.repository.Query
import ru.yandex.travel.hotels.extranet.entities.orders.BankOrder
import ru.yandex.travel.hotels.extranet.entities.orders.BankOrderDetailWebView
import java.time.Instant
import java.time.temporal.ChronoUnit

interface BankOrderDetailsWebViewRepository :
    JpaRepository<BankOrderDetailWebView, String> {

    fun findAllByIdPaymentBatchId(paymentBatchId: String): List<BankOrderDetailWebView>

    @Query(
        "FROM BankOrder WHERE paymentBatchId in (" +
            "SELECT id.paymentBatchId FROM BankOrderDetailWebView " +
            "WHERE id.orderId is null or forUpdate = true)" +
            " AND (calculateAttempts < 20 OR createdAt < ?1)" +
            " ORDER BY calculateAttempts"
    )
    fun findBankOrderForUpdate(
        staleThreshold: Instant = Instant.now().minus(1, ChronoUnit.DAYS),
        pageable: Pageable = PageRequest.of(0, 100)
    ): List<BankOrder>

    @Query(
        "FROM BankOrder bo" +
            " LEFT JOIN BankOrderDetailWebView wv on bo.paymentBatchId = wv.id.paymentBatchId" +
            " WHERE wv is null" +
            " AND (bo.calculateAttempts < 20 OR bo.createdAt < ?1)" +
            " ORDER BY bo.calculateAttempts"
    )
    fun findMissing(
        staleThreshold: Instant = Instant.now().minus(1, ChronoUnit.DAYS),
        pageable: Pageable = PageRequest.of(0, 100)
    ): List<BankOrder>
}
