package ru.yandex.travel.hotels.extranet.repository

import org.springframework.data.jpa.repository.JpaRepository
import org.springframework.data.jpa.repository.JpaSpecificationExecutor
import org.springframework.data.jpa.repository.Query
import org.springframework.stereotype.Repository
import ru.yandex.travel.hotels.extranet.entities.HotelIdentifier
import ru.yandex.travel.hotels.extranet.entities.orders.BankOrder
import ru.yandex.travel.hotels.extranet.entities.orders.BoYOrder
import ru.yandex.travel.hotels.extranet.service.bankorders.BankOrderToBoYOrderDTO

@Repository
interface BankOrdersRepository : JpaSpecificationExecutor<BankOrder>, JpaRepository<BankOrder, String> {
    @Query(
        "SELECT distinct new ru.yandex.travel.hotels.extranet.service.bankorders.BankOrderToBoYOrderDTO(" +
            "  bo.bankOrderId," +
            "  fe.order.id," +
            "  bo.eventTime)\n" +
            "FROM BankOrder bo" +
            "  JOIN bo.bankOrderDetails bod\n" +
            "  JOIN BillingTransaction bt on bt.ytId = bod.ytId\n" +
            "  JOIN bt.financialEvent fe\n" +
            "WHERE fe.order in ?1"
    )
    fun findBankOrdersForYtId(orders: List<BoYOrder>): Collection<BankOrderToBoYOrderDTO>

    @Query(
        "SELECT DISTINCT ha.hotelIdentifier" +
            " FROM BankOrder bo" +
            "  JOIN bo.bankOrderDetails bod\n" +
            "  JOIN BillingTransaction bt on bt.ytId = bod.ytId\n" +
            "  JOIN bt.financialEvent fe\n" +
            "  JOIN fe.order o\n" +
            "  JOIN o.hotelAgreement ha\n" +
            "WHERE bo.paymentBatchId = ?1"
    )
    fun findHotelsForPaymentBatchId(paymentBatchId: String): Collection<HotelIdentifier>
}
