package ru.yandex.travel.hotels.extranet.repository

import org.springframework.data.jpa.repository.JpaRepository
import org.springframework.stereotype.Repository
import ru.yandex.travel.hotels.extranet.IDMRoleType
import ru.yandex.travel.hotels.extranet.entities.IdmPermission

@Repository
interface IdmPermissionRepository : JpaRepository<IdmPermission, String> {
    fun findByPassportLoginAndRole(passportLogin: String, role: IDMRoleType): IdmPermission?
    fun findAllByPassportUid(passportUid: Long): List<IdmPermission>
    fun findAllByPassportLogin(passportLogin: String): List<IdmPermission>
    fun removeAllByLoginAndRole(login: String, role: IDMRoleType): Long
}
