package ru.yandex.travel.hotels.extranet.repository

import org.springframework.data.jpa.repository.JpaRepository
import org.springframework.data.jpa.repository.Query
import org.springframework.stereotype.Repository
import ru.yandex.travel.hotels.extranet.entities.Invitation
import ru.yandex.travel.hotels.extranet.entities.HotelIdentifier
import java.time.Instant
import java.util.UUID

@Repository
interface InvitationRepository : JpaRepository<Invitation, UUID> {
    @Query(
        "SELECT CASE WHEN COUNT(i)>0 THEN true ELSE false END " +
            "FROM Invitation i " +
            "WHERE i.passportId = :passportId " +
            "AND i.hotelIdentifier = :hotelIdentifier " +
            "AND i.requestExpiresAt > :now " +
            "AND i.approvedAt IS NULL"
    )
    fun haveActiveRequest(
        passportId: String,
        hotelIdentifier: HotelIdentifier,
        now: Instant = Instant.now(),
    ): Boolean

    @Query(
        "SELECT CASE WHEN COUNT(i)>0 THEN true ELSE false END " +
            "FROM Invitation i " +
            "WHERE i.passportId = :passportId " +
            "AND i.hotelIdentifier = :hotelIdentifier " +
            "AND i.approvedAt IS NOT NULL"
    )
    fun haveApprovedRequest(passportId: String, hotelIdentifier: HotelIdentifier): Boolean

    fun getByRequestToken(token: String): Invitation?

    @Query(
        "FROM Invitation i WHERE i.passportId = :passportId AND i.approvedAt IS NOT NULL"
    )
    fun listAuthorized(passportId: String): List<Invitation>
}
