package ru.yandex.travel.hotels.extranet.repository

import org.springframework.data.domain.PageRequest
import org.springframework.data.domain.Pageable
import org.springframework.data.domain.Sort
import org.springframework.data.jpa.repository.JpaRepository
import org.springframework.data.jpa.repository.Query
import org.springframework.data.repository.CrudRepository
import ru.yandex.travel.hotels.extranet.entities.ManualOverrideJobExecution

interface ManualOverrideJobExecutionRepository : JpaRepository<ManualOverrideJobExecution, Long> {
    @Query("FROM ManualOverrideJobExecution WHERE jobName = ?1 AND state = 'NEW'")
    fun getManualExecution(
        jobName: String,
        page: Pageable = PageRequest.of(0, 1, Sort.by(Sort.Direction.ASC, "id"))
    ): List<ManualOverrideJobExecution>
}
