package ru.yandex.travel.hotels.extranet.repository

import org.springframework.data.jpa.repository.JpaRepository
import org.springframework.data.jpa.repository.JpaSpecificationExecutor
import org.springframework.data.jpa.repository.Modifying
import org.springframework.data.jpa.repository.Query
import ru.yandex.travel.hotels.extranet.entities.orders.BOY_ORDER_VIEW_NAME
import ru.yandex.travel.hotels.extranet.entities.orders.BoYOrderWebView

interface OrdersWebViewRepository : JpaSpecificationExecutor<BoYOrderWebView>,
    JpaRepository<BoYOrderWebView, String>,
    AbstractWebViewRepo {
    @Modifying
    @Query(value = "REFRESH MATERIALIZED VIEW CONCURRENTLY $BOY_ORDER_VIEW_NAME", nativeQuery = true)
    override fun refreshMaterializedView()

    @Query(
        "FROM BoYOrderWebView WHERE id in (\n" +
            "  SELECT fe.order.id FROM FinancialEvent fe\n" +
            "  JOIN fe.billingTransactions bt WHERE bt.ytId = ?1\n" +
            ")"
    )
    fun findByYtId(ytId: Long): BoYOrderWebView?
}
