package ru.yandex.travel.hotels.extranet.repository

import org.springframework.data.jpa.repository.JpaRepository
import org.springframework.stereotype.Repository
import ru.yandex.travel.hotels.extranet.entities.RoomCategory

@Repository
interface RoomCategoryRepository : JpaRepository<RoomCategory, Long> {
    fun findAllByHotelIdAndDeletedIsFalse(hotelId: Long): List<RoomCategory>
    fun findAllByHotelIdAndIdInAndDeletedIsFalse(hotelId: Long, ids: Set<Long>): Set<RoomCategory>
    fun getRoomCategoryByHotelIdAndIdAndDeletedIsFalse(hotelId: Long, id: Long): RoomCategory
}
