package ru.yandex.travel.hotels.extranet.service

import org.springframework.batch.core.JobParameters
import org.springframework.batch.core.JobParametersBuilder
import org.springframework.stereotype.Service
import org.springframework.transaction.annotation.Transactional
import ru.yandex.travel.hotels.extranet.entities.ManualOverrideState
import ru.yandex.travel.hotels.extranet.extract.grpc.FROM_PROP
import ru.yandex.travel.hotels.extranet.extract.grpc.MANUAL_OVERRIDE
import ru.yandex.travel.hotels.extranet.extract.grpc.TILL_PROP
import ru.yandex.travel.hotels.extranet.repository.ManualOverrideJobExecutionRepository
import java.time.Instant
import java.util.Date

@Service
open class ManualJobService(private val overrideRepo: ManualOverrideJobExecutionRepository) : IManualJobOverrideService {

    @Transactional
    override fun getOverrideJobIfExists(jobName: String): JobParameters? {
        return overrideRepo.getManualExecution(jobName).firstOrNull()?.let {
            val jobParameters = JobParametersBuilder()
            jobParameters.addDate(FROM_PROP, Date.from(it.fromProp))
            jobParameters.addDate(TILL_PROP, Date.from(it.tillProp ?: Instant.now()))
            jobParameters.addLong(MANUAL_OVERRIDE, it.id)
            it.state = ManualOverrideState.STARTED
            overrideRepo.saveAndFlush(it)
            return jobParameters.toJobParameters()
        }
    }
}
