package ru.yandex.travel.hotels.extranet.service.content.rateplans

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import ru.yandex.travel.hotels.extranet.dto.RatePlanDTO
import ru.yandex.travel.hotels.extranet.entities.RatePlan
import ru.yandex.travel.hotels.extranet.service.content.annulation.AnnulationPolicyMapper
import ru.yandex.travel.hotels.extranet.service.content.roomcat.RoomCategoryMapper

@Component
class RatePlanMapper @Autowired constructor(
    private val policyMapper: AnnulationPolicyMapper,
    private val roomCategoryMapper: RoomCategoryMapper,
) {
    fun mapRatePlanToDto(ratePlan: RatePlan): RatePlanDTO {
        return RatePlanDTO.newBuilder()
            .setId(ratePlan.id ?: 0)
            .setName(ratePlan.name)
            .setDescription(ratePlan.description.orEmpty())
            .setAnnulationPolicy(policyMapper.mapToDto(ratePlan.annulationPolicy))
            .addAllRoomCategories(ratePlan.roomCategories.map { roomCategoryMapper.mapRoomCategoryShort(it) })
            .setDeleted(ratePlan.deleted)
            .setHidden(ratePlan.hidden)
            .setDisabled(ratePlan.disabled)
            .build()
    }
}
