package ru.yandex.travel.hotels.extranet.service.content.rateplans

import ru.yandex.travel.hotels.extranet.dto.RatePlanDTO

interface RatePlanService {
    fun listRatePlans(
        hotelId: Long,
        includeDisabled: Boolean = true,
        includeHidden: Boolean = true
    ): List<RatePlanDTO>

    fun addRatePlan(
        hotelId: Long,
        name: String,
        annulationPolicyId: Long,
        description: String? = null,
        roomCategoryIds: Set<Long> = emptySet()
    ): RatePlanDTO

    fun deleteRatePlan(hotelId: Long, id: Long)

    fun updateRatePlan(
        hotelId: Long,
        id: Long,
        name: String? = null,
        annulationPolicyId: Long? = null,
        description: String? = null,
        roomCategories: Set<Long>? = null
    ): RatePlanDTO

    fun getRatePlan(
        hotelId: Long,
        id: Long
    ): RatePlanDTO

    fun hideRatePlan(hotelId: Long, id: Long)

    fun showRatePlan(hotelId: Long, id: Long)

    fun disableRatePlan(hotelId: Long, id: Long)

    fun enableRatePlan(hotelId: Long, id: Long)
}
