package ru.yandex.travel.hotels.extranet.service.content.roomcat

import org.springframework.stereotype.Component
import ru.yandex.travel.hotels.extranet.dto.RoomCategoryDTO
import ru.yandex.travel.hotels.extranet.dto.RoomCategoryShortDTO
import ru.yandex.travel.hotels.extranet.dto.RoomPlacementDTO
import ru.yandex.travel.hotels.extranet.entities.RoomCategory
import ru.yandex.travel.hotels.extranet.entities.RoomPlacement

@Component
class RoomCategoryMapper {
    fun mapRoomCategory(roomCategory: RoomCategory): RoomCategoryDTO {
        return RoomCategoryDTO.newBuilder().setId(roomCategory.id!!).setName(roomCategory.name)
            .setDescription(roomCategory.description).setType(roomCategory.type.protoType)
            .setMaxPrimaryPlaces(roomCategory.maxPrimaryPlaces).setMaxExtraPlaces(roomCategory.maxExtraPlaces)
            .setDeleted(roomCategory.deleted).setDisabled(roomCategory.disabled).setHidden(roomCategory.hidden)
            .addAllPlacements(roomCategory.placements.map { mapPlacement(it) }).build()
    }

    fun mapRoomCategoryShort(roomCategory: RoomCategory): RoomCategoryShortDTO {
        return RoomCategoryShortDTO.newBuilder().setId(roomCategory.id ?: 0).setName(roomCategory.name).build()
    }

    private fun mapPlacement(placement: RoomPlacement): RoomPlacementDTO {
        return RoomPlacementDTO.newBuilder().setId(placement.id!!).setName(placement.name)
            .setPrimaryAdults(placement.primaryAdults).setExtraAdults(placement.extraAdults)
            .setDeleted(placement.deleted).setDisabled(placement.disabled).setHidden(placement.hidden).build()
    }
}
