package ru.yandex.travel.hotels.extranet.service.content.roomcat

import ru.yandex.travel.hotels.extranet.dto.RoomCategoryDTO
import ru.yandex.travel.hotels.extranet.dto.RoomCategoryType

interface RoomCategoryService {
    fun createRoomCategory(
        hotelId: Long,
        name: String,
        description: String,
        type: RoomCategoryType,
        maxPrimary: Int,
        maxExtra: Int,
        createDefaultPlacements: Boolean = true
    ): RoomCategoryDTO

    fun getRoomCategory(hotelId: Long, id: Long): RoomCategoryDTO

    fun deleteRoomCategory(hotelId: Long, id: Long)

    fun listRoomCategories(
        hotelId: Long,
        includeDisabled: Boolean = true,
        includeHidden: Boolean = true
    ): List<RoomCategoryDTO>

    fun hideRoomCategory(hotelId: Long, id: Long)

    fun showRoomCategory(hotelId: Long, id: Long)

    fun disableRoomCategory(hotelId: Long, id: Long)

    fun enableRoomCategory(hotelId: Long, id: Long)
}
