package ru.yandex.travel.hotels.extranet.service.invitations

import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.boot.context.properties.ConstructorBinding
import org.springframework.validation.annotation.Validated
import java.time.Duration

@ConstructorBinding
@ConfigurationProperties(prefix = "invitation-service", ignoreUnknownFields = false)
@Validated
data class InvitationServiceProperties(
    val invitationParams: InvitationParams,
    val allowAllFromYandexTeam: Boolean = false
) {
    @ConstructorBinding
    @Validated
    data class InvitationParams(
        val emailCampaign: String,
        val expirationDuration: Duration,
    )
}
