package ru.yandex.travel.hotels.extranet.service.notification

import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.boot.context.properties.ConstructorBinding
import org.springframework.validation.annotation.Validated
import javax.validation.constraints.NotEmpty

@ConstructorBinding
@ConfigurationProperties(prefix = "mail-sender", ignoreUnknownFields = false)
@Validated
data class MailSenderConfigurationProperties(
    val mailerUrlBase: @NotEmpty String,
    val authenticationKey: @NotEmpty String,
    val debug: DebugProperties = DebugProperties(),
) {
    @ConstructorBinding
    @Validated
    data class DebugProperties(
        val enabled: Boolean = false,
        val failEmail: String? = null,
    )
}
