package ru.yandex.travel.hotels.extranet.service.roles

import ru.yandex.travel.hotels.extranet.dto.OrganizationUserRoleDTO
import ru.yandex.travel.hotels.extranet.entities.HotelIdentifier
import ru.yandex.travel.hotels.extranet.entities.Permission
import ru.yandex.travel.hotels.extranet.entities.Role
import ru.yandex.travel.hotels.extranet.entities.User
import java.util.UUID

interface UserRoleService {
    fun grantRole(userId: Long, organizationId: UUID, role: Role, hotelId: Long? = null): UUID

    fun listOrgUsers(organizationId: UUID): List<OrganizationUserRoleDTO>

    fun revokeRole(id: UUID)

    fun checkPermission(
        permission: Permission,
        organizationId: UUID? = null,
        hotelId: Long? = null,
        hotelPartnerId: HotelIdentifier? = null,
    ): User

    fun getCurrentUser(): User?

    fun getCurrentUserOrThrow(): User
}
