package ru.yandex.travel.hotels.extranet.utils

import org.hibernate.engine.spi.SharedSessionContractImplementor
import org.hibernate.usertype.UserType
import java.io.Serializable
import java.sql.PreparedStatement
import java.sql.ResultSet

class PgListType : UserType {
    private val SQL_TYPES = intArrayOf(java.sql.Types.ARRAY)

    override fun hashCode(x: Any?): Int {
        return x?.hashCode() ?: 0
    }

    override fun returnedClass(): Class<*> {
        return List::class.java
    }

    override fun nullSafeGet(
        rs: ResultSet,
        names: Array<out String>,
        session: SharedSessionContractImplementor?,
        owner: Any?
    ): List<*>? {
        return rs.getArray(names[0])?.array?.let {
            listOf(*it as Array<*>)
        }
    }

    override fun nullSafeSet(
        st: PreparedStatement?,
        value: Any?,
        index: Int,
        session: SharedSessionContractImplementor?
    ) {
        throw UnsupportedOperationException()
    }

    override fun sqlTypes(): IntArray {
        return SQL_TYPES
    }

    override fun equals(x: Any?, y: Any?): Boolean {
        return if (x === y) true else if (x == null || y == null) false else x == y
    }

    override fun deepCopy(value: Any?): Any? = value

    override fun isMutable(): Boolean = false

    override fun disassemble(value: Any?): Serializable {
        throw UnsupportedOperationException()
    }

    override fun assemble(cached: Serializable?, owner: Any?): Any {
        throw UnsupportedOperationException()
    }

    override fun replace(original: Any?, target: Any?, owner: Any?): Any {
        throw UnsupportedOperationException()
    }
}
