package ru.yandex.travel.hotels.extranet.utils

import java.math.BigDecimal
import java.util.EnumSet

inline fun <reified T : Enum<T>> enumSetOf(vararg elems: T): EnumSet<T> =
    EnumSet.noneOf(T::class.java).apply {
        addAll(elems)
    }

fun BigDecimal.isInteger(): Boolean {
    return this.stripTrailingZeros().scale() <= 0
}
