package ru.yandex.travel.hotels.extranet.validation

    import javax.validation.Constraint
import javax.validation.Payload
import kotlin.reflect.KClass

@Constraint(validatedBy = [ValidAnnulationRuleItemValidator::class])
@Target(allowedTargets = [AnnotationTarget.CLASS])
@Retention(AnnotationRetention.RUNTIME)
@MustBeDocumented
annotation class ValidAnnulationRuleItem(
    val message: String =
        "Неверное правило валидации",

    @Suppress("unused")
    val groups: Array<KClass<*>> = [],

    @Suppress("unused")
    val payload: Array<KClass<out Payload>> = [],
)
