package ru.yandex.travel.hotels.extranet.validation

    import javax.validation.Constraint
import javax.validation.Payload
import kotlin.reflect.KClass

@Constraint(validatedBy = [ValidAnnulationRulesValidator::class])
@Target(allowedTargets = [AnnotationTarget.FIELD])
@Retention(AnnotationRetention.RUNTIME)
@MustBeDocumented
annotation class ValidAnnulationRules(
    val message: String =
        "Неверные правила валидации",

    @Suppress("unused")
    val groups: Array<KClass<*>> = [],

    @Suppress("unused")
    val payload: Array<KClass<out Payload>> = [],
)
