create table if not exists auth_permission
(
    id                 uuid not null
        constraint auth_permission_pkey
            primary key,
    approved_at        timestamp,
    created_at         timestamp,
    original_id        varchar(255),
    partner_id         varchar(30),
    passport_id        varchar(255),
    request_expires_at timestamp,
    request_token      varchar(36),
    updated_at         timestamp
);

create index if not exists idx_passport_hotel_approve_expire
    on auth_permission (passport_id, approved_at, partner_id, original_id, request_expires_at);

create table if not exists bank_orders
(
    payment_batch_id  varchar(20) not null
        constraint bank_orders_pkey
            primary key,
    bank_order_id     varchar(20),
    created_at        timestamp,
    description       varchar(1024),
    oebs_status       varchar(20),
    status            varchar(20),
    sum               numeric(10, 2),
    updated_at        timestamp,
    updated_at_in_orc timestamp,
    event_time        date
);

create table if not exists bank_order_details
(
    id               bigint  not null
        constraint bank_order_details_pkey
            primary key,
    contract_id      bigint  not null,
    created_at       timestamp,
    handling_time    timestamp,
    payment_time     timestamp,
    payment_type     varchar(20),
    sum              numeric(10, 2),
    transaction_type varchar(20),
    trust_payment_id integer not null,
    updated_at       timestamp,
    yt_id            bigint  not null,
    bank_order_id    varchar(20)
        constraint fk5p6v4yva5xtqgvqtlv0ijksd1
            references bank_orders,
    payment_batch_id varchar(20)
        constraint fkrpifux5d5m91uvx4wcdu4pavf
            references bank_orders
);

create index if not exists bank_order_details_yt_id_idx
    on bank_order_details (yt_id);

create index if not exists bank_orders_event_time_idx
    on bank_orders (event_time);

create index if not exists bank_orders_bank_order_id_idx
    on bank_orders (bank_order_id);

create table if not exists hotel_agreements
(
    id                    bigint not null
        constraint hotel_agreements_pkey
            primary key,
    agreement_end_date    timestamp,
    agreement_start_date  timestamp,
    created_at            timestamp,
    financial_client_id   bigint not null,
    financial_contract_id bigint not null,
    partner_id            varchar(30),
    original_id           varchar(20),
    order_confirmed_rate  varchar(20),
    order_refunded_rate   varchar(20),
    updated_at            timestamp
);

create UNIQUE INDEX if not exists hotel_agreements_hotel_id_idx
    on hotel_agreements (partner_id, original_id);

create index if not exists hotel_agreements_agreement_start_date_idx
    on hotel_agreements (agreement_start_date);

create index if not exists hotel_agreements_agreement_end_date_idx
    on hotel_agreements (agreement_end_date);

create table if not exists boy_orders
(
    id                     varchar(36) not null
        constraint boy_orders_pkey
            primary key,
    check_in_date          date,
    check_out_date         date,
    cost_after_reservation numeric(10, 2),
    created_at             timestamp,
    discount               numeric(10, 2),
    fiscal_price           numeric(10, 2),
    hotel_price            numeric(10, 2),
    order_cancelled_at     timestamp,
    order_created_at       timestamp,
    order_updated_at       timestamp,
    partner_order_id       varchar(100),
    payment_state          varchar(32),
    use_deferred           boolean,
    pretty_id              varchar(20)
        constraint boy_orders_pretty_id_idx
            unique,
    updated_at             timestamp,
    hotel_agreement_id     bigint
        constraint fk3if2lqaajypqeno7vpuvhf0ym
            references hotel_agreements
);

create index if not exists boy_orders_partner_order_id_idx
    on boy_orders (partner_order_id);

create index if not exists boy_orders_order_created_at_idx
    on boy_orders (order_created_at);

create index if not exists boy_orders_order_cancelled_at_idx
    on boy_orders (order_cancelled_at);

create index if not exists boy_orders_check_in_date_idx
    on boy_orders (check_in_date);

create index if not exists boy_orders_check_out_date_idx
    on boy_orders (check_out_date);

create index if not exists boy_orders_fiscal_price_idx
    on boy_orders (fiscal_price);

create table if not exists financial_events
(
    id                  bigint not null
        constraint financial_events_pkey
            primary key,
    billing_client_id   bigint not null,
    billing_contract_id bigint not null,
    fee_amount          numeric(10, 2),
    partner_amount      numeric(10, 2),
    payout_at           timestamp,
    order_id            varchar(36)
        constraint fk1eqgunoidj6490paovk0052fb
            references boy_orders
);

create table if not exists billing_transactions
(
    id                             bigint  not null
        constraint billing_transactions_pkey
            primary key,
    accounting_act_at              timestamp,
    act_committed                  boolean not null,
    created_at_billing_transaction timestamp,
    exported_to_yt                 boolean not null,
    payment_type                   varchar(20),
    payout_at                      timestamp,
    transaction_type               varchar(20),
    value                          numeric(10, 2),
    yt_id                          bigint,
    financial_event_id             bigint
        constraint fkifrw22hlkgw7fome6vfsgx7qi
            references financial_events
);

create table if not exists guests
(
    id         uuid    not null
        constraint guests_pkey
            primary key,
    age        integer,
    first_name varchar(255),
    guest_idx  integer not null,
    is_child   boolean not null,
    last_name  varchar(255),
    order_id   varchar(36)
        constraint fkiy3y535ukxt943sbwoofxmt5
            references boy_orders
);

create table if not exists manual_override_job_executions
(
    id         bigint not null
        constraint manual_override_job_executions_pkey
            primary key,
    created_at timestamp,
    from_prop  timestamp,
    job_name   varchar(255),
    state      varchar(20),
    till_prop  timestamp,
    updated_at timestamp,
    comment    varchar(1024)
);

