create table users(
	uid bigint not null
		constraint users_pkey
			primary key,
	blocked boolean not null default false,
	login varchar(50),
	created_at timestamp not null,
	updated_at timestamp not null
);

create table organizations
(
	id uuid not null
		constraint organizations_pkey
			primary key,
	name varchar(255) not null,
	created_at timestamp not null,
	updated_at timestamp not null
);

create table hotels
(
	id bigint not null
		constraint hotels_pkey
			primary key,

    permalink bigint,

	managed_by varchar(50),
	name varchar(255) not null,
	original_id varchar(15),
	partner_id varchar(50),

	organization_id uuid not null
		constraint hotels_organization_fk references organizations,

	updated_at timestamp not null,
	created_at timestamp not null
);

create table user_role_bindings
(
	id uuid not null
		constraint user_role_bindings_pkey
			primary key,
	idm_login varchar(50),
	role varchar(50) not null,
	hotel_id bigint
		constraint role_bining_hotel_fk
			references hotels,
	organization_id uuid
		constraint role_bining_organization_fk
			references organizations,
	user_uid bigint not null
		constraint role_bining_user_fk
			references users
);

create sequence hotels_id_seq start with 10000;
