create TABLE room_categories(
    id bigint NOT NULL
        constraint room_categories_pkey
            primary key,
    hotel_id bigint NOT NULL
        constraint hotels_fk references hotels(id),
    deleted boolean NOT NULL,
    description character varying(255),
    disabled boolean NOT NULL,
    hidden boolean NOT NULL,
    max_extra_places integer NOT NULL,
    max_primary_places integer NOT NULL,
    name character varying(255),
    type character varying(50) NOT NULL,
    created_at timestamp,
    updated_at timestamp
);

create sequence room_categories_id_seq start with 2000;

create TABLE room_placements
(
	id bigint not null
		constraint room_placements_pkey
			primary key,
	deleted boolean not null,
	disabled boolean not null,
	extra_adults integer not null,
	hidden boolean not null,
	name varchar(255) not null,
	primary_adults integer not null,

	room_category_id bigint
		constraint room_categories_fk
			references room_categories,
	item_id integer,
	created_at timestamp,
	updated_at timestamp
);

create sequence room_placements_id_seq start with 1;
