CREATE TABLE rate_plans
(
    id bigint NOT NULL
        CONSTRAINT rate_plans_pk
            PRIMARY KEY,
    hotel_id bigint NOT NULL
        CONSTRAINT rateplans_hotels_fk
            REFERENCES hotels,
    annulation_policy_id bigint NOT NULL
        CONSTRAINT rateplans_policies_fk
            REFERENCES annulation_policies,
    name character varying(255) NOT NULL,
    description character varying(255),
    deleted boolean not null,
    hidden boolean not null,
    disabled boolean not null,
	created_at timestamp,
	updated_at timestamp
);

CREATE TABLE rate_plans_to_room_categories
(
	rate_plan_id bigint not null
		constraint rate_plans_to_room_categories_rate_plans_fk
			references rate_plans,
	room_category_id bigint not null
		constraint rate_plans_to_room_categories_room_categories_fk
			references room_categories,
	constraint rate_plans_to_room_categories_pkey
		primary key (rate_plan_id, room_category_id)
);

create sequence rate_plans_id_seq start with 100;
