DROP INDEX IF EXISTS boy_orders_partner_order_id_idx;

DROP INDEX IF EXISTS boy_orders_order_created_at_idx;

DROP INDEX IF EXISTS boy_orders_order_cancelled_at_idx;

DROP INDEX IF EXISTS boy_orders_check_in_date_idx;

DROP INDEX IF EXISTS boy_orders_check_out_date_idx;

DROP INDEX IF EXISTS boy_orders_fiscal_price_idx;


-- the job update was adding another set of guests with every order update
-- the reason: wrong pkey configuration.

DELETE
FROM guests
WHERE ID in
      (SELECT ID
       FROM (SELECT *,
                    row_number() over (partition by order_id order by guest_idx) as rn
             FROM guests
            ) a
       WHERE rn > 1);

alter table guests drop constraint guests_pkey;

drop index if exists guests_pkey;

alter table guests drop column id;

-- needed for h2 only, in pg it's not null already
alter table guests alter column order_id set not null;

alter table guests
    add constraint guests_pkey
        primary key (guest_idx, order_id);
