DROP VIEW boy_orders_web_view_v1;

CREATE VIEW boy_orders_web_view_v1
AS

SELECT ha.partner_id,
       ha.original_id,
       o.*,
       payout_at,
       partner_amount,
       fee_amount,
       first_name                 as guest_first_name,
       last_name                  as guest_last_name,
       status_localized.rus_local as order_status_rus,
       bank_orders_array,
       bank_orders_event_times

FROM (SELECT *,
             -- as for statuses, not yet clear where is the optimal place to calculate it
             -- we calculate it here with assumption that in future the logic won't become significantly more complicated
             -- and that it's likely that we'll need to make searching & sorting by status.
             -- Otherwise it can be moved back to java
             CASE
                 WHEN order_cancelled_at is not null OR payment_state = 'PS_CANCELLED' OR
                      hotel_order_state in ('OS_CANCELLED',
                                            'OS_REFUNDED')
                     THEN 'EOS_REFUNDED'
                 WHEN payment_state <> 'PS_FULLY_PAID' THEN 'EOS_AWAITS_PAYMENT'
                 WHEN check_out_date < now() THEN 'EOS_SERVED'
                 ELSE 'EOS_PREPAID'
                 END AS order_status
      FROM boy_orders) o
         JOIN hotel_agreements ha on o.hotel_agreement_id = ha.id
         LEFT JOIN (SELECT first_name,
                           last_name,
                           order_id,
                           row_number() over (partition by order_id order by guest_idx) as rn
                    FROM guests
                    ORDER BY guest_idx) g on g.order_id = o.id and g.rn = 1
         LEFT JOIN (SELECT max(payout_at)      as payout_at,
                           sum(partner_amount) as partner_amount,
                           sum(fee_amount)     as fee_amount,
                           fe.order_id
                    FROM financial_events fe
                    GROUP BY order_id) as fin_events_ag ON fin_events_ag.order_id = o.id
    -- ============ DIFF START ================
         LEFT JOIN (SELECT order_id,
                           array_agg(event_time)    AS bank_orders_event_times,
                           array_agg(bank_order_id) AS bank_orders_array
                    FROM (
                             SELECT fe.order_id,
                                    bo.event_time,
                                    bo.bank_order_id
                             FROM financial_events fe
                                      JOIN billing_transactions bt ON fe.id = bt.financial_event_id
                                      JOIN bank_order_details bod ON bt.yt_id = bod.yt_id
                                      JOIN bank_orders bo ON bod.payment_batch_id::text = bo.payment_batch_id::text
                             GROUP BY fe.order_id, bo.bank_order_id, bo.event_time
                         ) AS A
                         -- ============ DIFF END ================
                    GROUP BY order_id) as bank_orders ON bank_orders.order_id = o.id
         LEFT JOIN (SELECT *
                    FROM (VALUES ('EOS_PREPAID', 'Предоплачена'),
                                 ('EOS_AWAITS_PAYMENT', 'Ожидает оплаты'),
                                 ('EOS_REFUNDED', 'Отменена'),
                                 ('EOS_SERVED', 'Отжита'))
                             AS t(proto, rus_local)) as status_localized on status_localized.proto = o.order_status
;
