DROP MATERIALIZED VIEW IF EXISTS bank_order_details_web_view_v1 CASCADE;

CREATE MATERIALIZED VIEW IF NOT EXISTS bank_order_details_web_view_v1
AS

SELECT *
FROM (
         SELECT fe.order_id,
                bt.transaction_type,
                sum(bod.sum) as paid_amount,
                bo.payment_batch_id,
                bo.bank_order_id
         FROM bank_orders bo
                  JOIN bank_order_details bod
                       on bo.payment_batch_id = bod.payment_batch_id
                  JOIN billing_transactions bt on bod.yt_id = bt.yt_id
                  JOIN financial_events fe on bt.financial_event_id = fe.id
         WHERE bod.payment_type in ('BTPT_COST', 'YANDEX_ACCOUNT_COST_WITHDRAW')
-- see PartnerTransactionFetcher#fetchPartnerPaymentOrderTransactions
         GROUP BY fe.order_id, bt.transaction_type, bo.payment_batch_id, bo.bank_order_id
     ) billing
         JOIN (
    SELECT o.id,
           o.pretty_id,
           o.partner_order_id,
           o.created_at as order_created_at,
           o.check_in_date,
           o.check_out_date,
           o.fiscal_price,
           o.hotel_price,
           g.first_name as guest_first_name,
           g.last_name  as guest_last_name,
           ha.original_id,
           ha.partner_id
    FROM boy_orders o
             LEFT JOIN (SELECT first_name,
                               last_name,
                               order_id,
                               row_number() over (partition by order_id order by guest_idx) as rn
                        FROM guests
                        ORDER BY guest_idx) g on g.order_id = o.id and g.rn = 1
             JOIN hotel_agreements ha on o.hotel_agreement_id = ha.id) orders on orders.id = billing.order_id
WITH NO DATA;

CREATE INDEX bank_order_details_web_view_bank_order_id
    ON bank_order_details_web_view_v1 (bank_order_id);

REFRESH MATERIALIZED VIEW bank_order_details_web_view_v1;

ALTER TABLE bank_order_details DROP COLUMN IF EXISTS bank_order_id;
