INSERT INTO organizations(id, name, created_at, updated_at)
SELECT
       uuid_generate_v4(),
       (CASE when partner_id = 'PI_TRAVELLINE' then 'Travelline' else 'Bnovo' end) || '-отель ' || original_id,
       now(),
       now()
FROM invitations
where approved_at is not null
group by partner_id, original_id;


INSERT INTO hotels(id, managed_by, name, original_id, partner_id, organization_id, updated_at, created_at)
SELECT nextval('hotels_id_seq'),
       (CASE when partner_id = 'PI_TRAVELLINE' then 'TRAVELLINE' else 'BNOVO' end),
       name,
       original_id,
       partner_id,
       o.id,
       now(),
       now()
FROM invitations
join organizations o on o.name = ((CASE when partner_id = 'PI_TRAVELLINE' then 'Travelline' else 'Bnovo' end) || '-отель ' || original_id)
where approved_at is not null
group by partner_id, original_id, name, o.id;


INSERT INTO users(uid, created_at, updated_at)
select cast(passport_id as bigint), now(), now()
FROM invitations
where approved_at is not null
group by passport_id;


INSERT INTO user_role_bindings(id, role, organization_id, user_uid)
SELECT uuid_generate_v4(), 'MINOR_EXTRANET_VIEWER', o.id, cast(passport_id as bigint)
FROM invitations
join organizations o on o.name = ((CASE when partner_id = 'PI_TRAVELLINE' then 'Travelline' else 'Bnovo' end) || '-отель ' || original_id)
where approved_at is not null
group by o.id, passport_id;
