-- CALL create_manual_job('2022-01-01'::timestamp, _comment := 'need to relaunch, there were some mistakes')
CREATE SEQUENCE IF NOT EXISTS manual_override_job_id_seq START 100;

CREATE OR REPLACE PROCEDURE create_manual_job(
    start_at timestamp DEFAULT '2018-01-01',
    end_at timestamp DEFAULT null,
    job_names varchar[] DEFAULT ARRAY ['Sync Bank Info', 'Sync Orders Job'],
    _comment text DEFAULT null
) AS
$$
DECLARE
    job_name varchar;
    new_id   numeric;
BEGIN
    FOREACH job_name IN ARRAY job_names
        LOOP
            new_id := nextval('manual_override_job_id_seq');
            INSERT INTO manual_override_job_executions(id, created_at, from_prop, job_name, state, till_prop,
                                                       updated_at, comment)
            VALUES (new_id, now(), start_at, job_name, 'NEW', COALESCE(end_at, start_at + '1 week'), now(), _comment);
            RAISE INFO 'Created a manual execution: % id=%, from=%, till=%', job_name, new_id, start_at, end_at;
        END LOOP;
END;
$$ LANGUAGE plpgsql;

