RECURSE(
    src/test
)

JAVA_PROGRAM(hotels-extranet)
JDK_VERSION(11)
INCLUDE(${ARCADIA_ROOT}/travel/library/java/dependencies.inc)
INCLUDE(${ARCADIA_ROOT}/travel/library/java/lombok.inc)

OWNER(g:travel)

WITH_KOTLIN()
WITH_KOTLINC_ALLOPEN(
    preset=spring
    annotation=javax.persistence.Entity
)
WITH_KOTLINC_NOARG(preset=jpa)
JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)

PEERDIR(
    travel/library/java/spring-boot-skeleton
    travel/library/java/ha-grpc-client
    travel/library/java/master-lock-manager
    travel/library/java/yt-lucene-index
    contrib/java/org/springframework/boot/spring-boot-starter-batch
    contrib/java/org/springframework/boot/spring-boot-starter-validation


    # DTO interaces
    travel/hotels/proto/extranet_api

    # DB-related
    contrib/java/org/springframework/boot/spring-boot-starter-data-jpa
    contrib/java/org/flywaydb/flyway-core

    contrib/java/com/h2database/h2
    contrib/java/org/postgresql/postgresql


    # Other
    contrib/java/org/jetbrains/kotlin/kotlin-reflect
    contrib/java/com/fasterxml/jackson/module/jackson-module-kotlin
)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/travel/hotels/devops/starter/starter.template.py
    OUT ${BINDIR}/bin/extranet.py
    CUSTOM_PROPERTY appName hotels-extranet
    # that's the class where compiler puts main method
    CUSTOM_PROPERTY mainClass ru.yandex.travel.hotels.extranet.ExtranetApplicationKt
)

LINT(base)
END()
