# coding=utf-8

from collections import OrderedDict

LINK = 'link'
CUSTOM_TAGS = 'custom_tags'


def merge_photo_duplicates(photo_collection):
    """
    Merges photo collection
    :param photo_collection: a collection of photos
    :return: a collection of photos where similar LINK are merged
    """
    d = OrderedDict()
    for photo in photo_collection:
        if photo[LINK] not in d:
            d[photo[LINK]] = photo
        else:
            if photo.get(CUSTOM_TAGS, None) is not None:
                if d[photo[LINK]].get(CUSTOM_TAGS, None) is None:
                    d[photo[LINK]][CUSTOM_TAGS] = photo[CUSTOM_TAGS]
                else:
                    tags = OrderedDict({k: None for k in d[photo[LINK]][CUSTOM_TAGS]})
                    tags.update({k: None for k in photo[CUSTOM_TAGS]})
                    d[photo[LINK]][CUSTOM_TAGS] = sorted(tags.keys())

    return list(d.values())
