# coding=utf-8
from enum import Enum


class NameType(Enum):
    MAIN = 0
    SHORT = 1
    LEGAL = 2
    OBSOLETE = 3
    SYNONYM = 4
    SERVICE = 5


class PhoneType(Enum):
    PHONE = 1
    FAX = 2


class UrlType(Enum):
    # отгружаются как Url. providerId не нужен для экспорта
    MAIN = 0
    # отгружаются как Url. providerId не нужен для экспорта
    ALTERNATIVE = 1
    # отгружаются как Url. providerId не нужен для экспорта
    MIRROR = 2
    # Отгружаются как Link. Url является ссылкой на страницу соцсети. В качестве providerId указывается id соцсети
    SOCIAL = 3
    # Отгружаются как Link. Нужен для отображения ссылок на страницы партнерских сайтов.
    ATTRIBUTION = 4
    # отгружаются как Link. Системный Url. Служит для выдачи выдачи в экспорт спецссылки афишу.
    SHOWTIMES = 5
    # отгружаются как Link. Системный Url. Служит для выдачи выдачи в экспорт спецссылки на https://booking.yandex.ru
    BOOKING = 6
    # Должен отгружатся как Ling, нужен provider_id https://st.yandex-team.ru/ALTAY-2817
    MINING = 7
    MENU = 8
    DEEPLINK = 9
    # урл филиала сети ALTAY-5428
    CHAIN_BRANCH = 10


class PageType(Enum):
    FILIAL = 0
    SITE = 1


class Language(Enum):
    TRANSLIT = 999
    UNDEFINED = 1000

    # Afar
    AA = 1002
    # Abkhazian
    AB = 1003
    # Avestan
    AE = 1004
    # Afrikaans
    AF = 1005
    # Akan
    AK = 1006
    # Amharic
    AM = 1007
    # Aragonese
    AN = 1008
    # Arabic
    AR = 1009
    # Assamese
    AS = 1010
    # Avaric
    AV = 1011
    # Aymara
    AY = 1012
    # Azerbaijani
    AZ = 1013
    # Bashkir
    BA = 1014
    # Belarusian
    BE = 6
    # Bulgarian
    BG = 11
    # Bihari languages
    BH = 1015
    # Bislama
    BI = 1016
    # Bambara
    BM = 1017
    # Bengali
    BN = 1018
    # Tibetan
    BO = 1019
    # Breton
    BR = 1020
    # Bosnian
    BS = 1021
    # Catalan, Valencian
    CA = 1022
    # Chechen
    CE = 1023
    # Chamorro
    CH = 1024
    # Corsican
    CO = 1025
    # Cree
    CR = 1026
    # Czech
    CS = 1027
    # Church Slavic, Church Slavonic, Old Bulgarian, Old Church Slavonic, Old Slavonic
    CU = 1028
    # Chuvash
    CV = 1029
    # Welsh
    CY = 1030
    # Danish
    DA = 1031
    # German
    DE = 10
    # Dhivehi, Divehi, Maldivian
    DV = 1032
    # Dzongkha
    DZ = 1033
    # Ewe
    EE = 1034
    # Modern Greek (1453-)
    EL = 1035
    # English
    EN = 3
    # Esperanto
    EO = 1036
    # Spanish, Castilian
    ES = 1037
    # Estonian
    ET = 19
    # Basque
    EU = 1038
    # Persian
    FA = 1039
    # Fulah
    FF = 1040
    # Finnish
    FI = 16
    # Fijian
    FJ = 1041
    # Faroese
    FO = 1042
    # French
    FR = 9
    # Western Frisian
    FY = 1043
    # Irish
    GA = 1044
    # Scottish Gaelic, Gaelic
    GD = 1045
    # Galician
    GL = 1046
    # Guarani
    GN = 1047
    # Gujarati
    GU = 1048
    # Manx
    GV = 1049
    # Hausa
    HA = 1050
    # Hebrew
    HE = 1051
    # Hindi
    HI = 1052
    # Hiri Motu
    HO = 1053
    # Croatian
    HR = 14
    # Haitian, Haitian Creole
    HT = 1054
    # Hungarian
    HU = 1055
    # Armenian
    HY = 1056
    # Herero
    # HZ = 1057
    # Interlingua (International Auxiliary Language Association)
    IA = 1058
    # Indonesian
    ID = 1059
    # Interlingue, Occidental
    IE = 1060
    # Igbo
    IG = 1061
    # Sichuan Yi, Nuosu
    II = 1062
    # Inupiaq
    IK = 1063
    # Indonesian
    IN = 1064
    # Ido
    IO = 1065
    # Icelandic
    IS = 1066
    # Italian
    IT = 8
    # Inuktitut
    IU = 1067
    # Hebrew
    IW = 1068
    # Japanese
    JA = 1069
    # Yiddish
    JI = 1070
    # Javanese
    JV = 1071
    # Javanese
    JW = 1072
    # Georgian
    KA = 1073
    # Kongo
    KG = 1074
    # Kikuyu, Gikuyu
    KI = 1075
    # Kuanyama, Kwanyama
    KJ = 1076
    # Kazakh
    KK = 5
    # Kalaallisut, Greenlandic
    KL = 1077
    # Central Khmer
    KM = 1078
    # Kannada
    KN = 1079
    # Korean
    KO = 1080
    # Kanuri
    KR = 1081
    # Kashmiri
    KS = 1082
    # Kurdish
    KU = 1083
    # Komi
    KV = 1084
    # Cornish
    KW = 1085
    # Kirghiz, Kyrgyz
    KY = 1086
    # Latin
    LA = 1087
    # Luxembourgish, Letzeburgesch
    LB = 1088
    # Ganda
    LG = 1089
    # Limburgan, Limburger, Limburgish
    LI = 1090
    # Lingala
    LN = 1091
    # Lao
    LO = 1092
    # Lithuanian
    LT = 1093
    # Luba-Katanga
    LU = 1094
    # Latvian
    LV = 1095
    # Malagasy
    MG = 1096
    # Marshallese
    MH = 1097
    # Maori
    MI = 1098
    # Macedonian
    MK = 12
    # Malayalam
    ML = 1099
    # Mongolian
    MN = 1100
    # Moldavian, Moldovan
    MO = 1101
    # Marathi
    MR = 1102
    # Malay (macrolanguage)
    MS = 1103
    # Maltese
    MT = 1104
    # Burmese
    MY = 1105
    # Nauru
    NA = 1106
    # Norwegian Bokmål
    NB = 1107
    # North Ndebele
    ND = 1108
    # Nepali
    NE = 1109
    # Ndonga
    NG = 1110
    # Dutch, Flemish
    NL = 1111
    # Norwegian Nynorsk
    NN = 1112
    # Norwegian
    NO = 1113
    # South Ndebele
    NR = 1114
    # Navajo, Navaho
    NV = 1115
    # Nyanja, Chewa, Chichewa
    NY = 1116
    # Occitan (post 1500)
    OC = 1117
    # Ojibwa
    OJ = 1118
    # Oromo
    OM = 1119
    # Oriya
    OR = 1120
    # Ossetian, Ossetic
    OS = 1121
    # Panjabi, Punjabi
    PA = 1122
    # Pali
    PI = 1123
    # Polish
    PL = 17
    # Pushto, Pashto
    PS = 1124
    # Portuguese
    PT = 1125
    # Quechua
    QU = 1126
    # Romansh
    RM = 1127
    # Rundi
    RN = 1128
    # Romanian, Moldavian, Moldovan
    RO = 13
    # Russian
    RU = 1
    # Kinyarwanda
    RW = 1129
    # Sanskrit
    SA = 1130
    # Sardinian
    SC = 1131
    # Sindhi
    SD = 1132
    # Northern Sami
    SE = 1133
    # Sango
    SG = 1134
    # Serbo-Croatian
    SH = 1135
    # Sinhala, Sinhalese
    SI = 1136
    # Slovak
    SK = 1137
    # Slovenian
    SL = 15
    # Samoan
    SM = 1138
    # Shona
    SN = 1139
    # Somali
    SO = 1140
    # Albanian
    SQ = 1141
    # Serbian
    SR = 1142
    # Swati
    SS = 1143
    # Southern Sotho
    ST = 1144
    # Sundanese
    SU = 1145
    # Swedish
    SV = 1146
    # Swahili (macrolanguage)
    SW = 1147
    # Tamil
    TA = 1148
    # Telugu
    TE = 1149
    # Tajik
    TG = 1150
    # Thai
    TH = 1151
    # Tigrinya
    TI = 1152
    # Turkmen
    TK = 1153
    # Tagalog
    TL = 1154
    # Tswana
    TN = 1155
    # Tonga (Tonga Islands)
    TO = 1156
    # Turkish
    TR = 4
    # Tsonga
    TS = 1157
    # Tatar
    TT = 1158
    # Twi
    TW = 1159
    # Tahitian
    TY = 1160
    # Uighur, Uyghur
    UG = 1161
    # Ukrainian
    UK = 2
    # Urdu
    UR = 1162
    # Uzbek
    UZ = 1163
    # Venda
    VE = 1164
    # Vietnamese
    VI = 18
    # Volapük
    VO = 1165
    # Walloon
    WA = 1166
    # Wolof
    WO = 1167
    # Xhosa
    XH = 1168
    # Yiddish
    YI = 1169
    # Yoruba
    YO = 1170
    # Zhuang, Chuang
    ZA = 1171
    # Chinese
    ZH = 1172
    # Zulu
    ZU = 1173


class HotelRubric(Enum):
    HOTEL = "184106414"  # Hotel, 30785
    DORMITORY = "184106316"  # Dormitory, 30655
    HOSTEL = "20699506347"  # Hostel, 31632
    CAMPING_AREA = "184106420"  # Camping area, 30788
    APARTMENTS_FOR_DAILY_RENT = "150049871970"  # Apartments for daily rent, 3501492236
    RURAL_TOURISM = "255921949"  # Rural Tourism, 31309
    RESORT = "184106404"  # Resort (Sanatorium), 30781
    REST_HOUSE = "184106400"  # Resort, 30779
    TOURIST_RESORT = "184106426"  # tourist resort, 30791
    CHILDREN_CAMP = "184106418"  # summer camp, 30787
    ACCOMMODATION_FOR_DAILY_RENT = "197061821387"  # Accommodation for daily rent, 3501708107


class PublishingStatus(Enum):
    # публиковать
    PUBLISH = 0
    # информация устарела
    OBSOLETE = 1
    # организация закрылась
    CLOSED = 2
    # отказались от предоставления информации (потребовали не публиковать информацио о них)
    DENIED_PUBLISHING = 3
    # организация является дублем другой
    DUPLICATE = 4
    # неверные данные, спам
    SPAM = 5
    # причина неизвестна
    UNKNOWN = 6
    # непроверенные данные
    UNCHECKED = 7
    # неправильный телефон
    WRONG_PHONE = 8
    # квартира
    APARTMENT = 9
    # не дозвонились
    NOT_ANSWERED = 10
    # организация переехала
    MOVED = 11
    # закрыто поставщиком
    CLOSED_BY_PROVIDER = 12
    # неверные данные, геоспам
    GEO_SPAM = 13
    # временно закрыта
    TEMPORARILY_CLOSED = 14
    # юр.адрес
    LEGAL_ADDRESS = 15
    #  для карточек только из нелегальных данных
    ILLEGAL_DATA = 16
    #  нет сигналов в карточке
    NO_SIGNALS = 17
    #  не вылезло имя или адрес из мержа, не получается сделать минимальную карточку
    NOT_ENOUGH_DATA = 18
    #  запрещено к публикации по юридическим аспектам (например, военные базы в Турции)
    FORBIDDEN_PUBLISH = 19
    # статус публикации не определен
    UNDEFINED = 999
