import json
import re
import logging
import argparse

import requests

from travel.hotels.feeders.partners.expedia.lib.helpers import gen_expedia_headers


def get_expedia_country_mapping(api_key, secret, lang="en-US", customer_ip="127.0.0.1"):
    url = "https://test.ean.com/2.1/regions/0/descendants?language={lang}&include=details".format(lang=lang)
    rsp = requests.get(url, headers=gen_expedia_headers(api_key=api_key, secret=secret, customer_ip=customer_ip))

    data = rsp.content
    re_line = '"type":"country","name":"([^"]*)","name_full":"[^"]*","country_code":"([^"]*)"'
    rxp = re.compile(re_line)
    countries = rxp.findall(data)
    return {c[1]: c[0] for c in countries}


def main():
    logging.basicConfig(level=logging.INFO)

    parser = argparse.ArgumentParser()
    parser.add_argument('--secret', required=True)
    parser.add_argument('--api-key', required=True)
    args = parser.parse_args()

    logging.info('Start loading expedia country mapping')
    country_mapping = get_expedia_country_mapping(api_key=args.api_key, secret=args.secret)
    logging.info('Country mapping successfully loaded')

    with open('country_mapping.json', 'w') as f:
        json.dump(country_mapping, f, indent=2, sort_keys=True)


if __name__ == '__main__':
    main()
