#pragma once

#include <utility>

#include "features_filtering.h"

namespace NTravel::NGeoCounter {
    struct TAdditionalFilter {
        enum EType {
            Single,
            Or,
            And,
        };

        TAdditionalFilter(int groupId, TAdditionalFilter::EType type, std::unique_ptr<TFilterBase> filter)
            : GroupId(groupId)
            , Type(type)
            , Filter(std::move(filter))
        {
        }

        int GroupId;
        EType Type;
        std::unique_ptr<TFilterBase> Filter;
    };
}