#pragma once

#include <travel/hotels/lib/cpp/util/url.h>
#include <travel/hotels/lib/cpp/tvm/tvm_service.h>
#include <travel/hotels/lib/cpp/mon/tools.h>
#include <travel/hotels/proto/app_config/bigb_client.pb.h>

#include <yabs/proto/user_profile.pb.h>

namespace NTravel::NGeoCounter {
    class TBigbClient {
    public:
        struct TRequest {
            TString YandexUid;
            TMaybe<TString> PassportUid;
        };

        TBigbClient(const NTravel::NTvm::TTvmService& tvmService, const NTravelProto::NAppConfig::TBigbClientConfig& bigbClientConfig);

        void RegisterCounters(NMonitor::TCounterSource& counters);

        std::pair<bool, TString> IsValidRequest(const TRequest& request) const;
        yabs::proto::Profile GetProfile(const TRequest& request) const;
    private:
        struct TCounters : public NMonitor::TCounterSource {
            TCounters();

            NMonitor::TDerivCounter NRequestErrors;
            NMonitor::TDerivCounter NRequests;

            NMonitor::TDerivHistogramCounter RequestTimeMs;

            void QueryCounters(NMonitor::TCounterTable* ct) const override;
        };

        const NTravel::NTvm::TTvmService& TvmService_;
        const TUrl BaseUrl_;
        const TString TvmDstAlias_;
        const TDuration Timeout_;
        mutable TCounters Counters_;
    };
}
