#include "boy_partner_provider.h"

namespace NTravel::NGeoCounter {
    TBoyPartnerProvider::TBoyPartnerProvider(const NTravelProto::NAppConfig::TYtTableCacheConfig& config)
        : YtConfigPartners_("YtConfigPartners", config)
    {
        YtConfigPartners_.SetOnUpdateHandler([this](bool first) {
            HandleUpdate(first);
        });
    }


    void TBoyPartnerProvider::RegisterCounters(NMonitor::TCounterSource& source) {
        YtConfigPartners_.RegisterCounters(source);
    }

    void TBoyPartnerProvider::Start() {
        YtConfigPartners_.Start();
    }

    void TBoyPartnerProvider::Stop() {
        YtConfigPartners_.Stop();
    }

    void TBoyPartnerProvider::AddOnUpdateHandler(std::function<void(void)> handler) {
        UpdateHandlers_.push_back(handler);
    }

    bool TBoyPartnerProvider::IsReady() const {
        return YtConfigPartners_.IsReady();
    }

    std::shared_ptr<TVector<NTravelProto::EPartnerId>> TBoyPartnerProvider::GetBoYPartnerIds() const {
        TReadGuard g(BoYPartnerIdsLock_);
        if (!BoYPartnerIds_) {
            ERROR_LOG << "BoYPartnerIds_ is null" << Endl;
            throw yexception() << "BoYPartnerIds_ is null";
        }
        return BoYPartnerIds_;
    }

    void TBoyPartnerProvider::HandleUpdate(bool) {
        auto partners = YtConfigPartners_.GetAll();
        auto boyPartnerIds = std::make_shared<TVector<NTravelProto::EPartnerId>>();
        for (const auto&[pId, partner]: *partners) {
            if (partner.GetIsBoY()) {
                boyPartnerIds->push_back(pId);
            }
        }
        {
            TWriteGuard g(BoYPartnerIdsLock_);
            BoYPartnerIds_ = boyPartnerIds;
        }

        for (auto& handler: UpdateHandlers_) {
            handler();
        }
    }
}
