#pragma once

#include <travel/hotels/proto2/hotels.pb.h>

#include <travel/hotels/proto/app_config/yt_table_cache.pb.h>
#include <travel/hotels/proto/data_config/partner.pb.h>
#include <travel/hotels/geocounter/proto/config.pb.h>
#include <travel/hotels/lib/cpp/mon/page.h>
#include <travel/hotels/lib/cpp/yt/persistent_config.h>

#include <util/system/rwlock.h>

#include <memory>

namespace NTravel::NGeoCounter {
    class TBoyPartnerProvider {
    public:
        TBoyPartnerProvider(const NTravelProto::NAppConfig::TYtTableCacheConfig& config);

        void RegisterCounters(NMonitor::TCounterSource& source);
        void Start();
        void Stop();
        void AddOnUpdateHandler(std::function<void(void)> handler);
        bool IsReady() const;

        std::shared_ptr<TVector<NTravelProto::EPartnerId>> GetBoYPartnerIds() const;

    private:
        void HandleUpdate(bool first);

        TYtPersistentConfig<NTravelProto::EPartnerId, NTravelProto::NConfig::TPartner> YtConfigPartners_;

        TRWMutex BoYPartnerIdsLock_;
        std::shared_ptr<TVector<NTravelProto::EPartnerId>> BoYPartnerIds_;

        TVector<std::function<void(void)>> UpdateHandlers_;
    };
}
