#include "utils.h"

#include <util/generic/ymath.h>

// Mostly copied from https://a.yandex-team.ru/arcadia/extsearch/geo/kernel/common/coords.cpp?rev=r9700078

namespace NWGS84 {
    /* Radius of reference ellipsoid, default to WGS 84 */
    const double R = 6378137.0;

    const double _a = R;
    const double _f = 1.0 / 298.257223563;
    const double _b = _a - _f * _a;
    const double _e = sqrt(1 - pow(_b / _a, 2));
    const double _e2 = _e * _e;
    const double _g = sqrt(1.0 - _e2);
}

namespace {
    double Deg2Rad(double d) {
        return d * PI / 180;
    }
}

namespace NTravel::NGeoCounter {
    double GetDistanceMeters(const TPosition& lhs, const TPosition& rhs) {
        // copied from https://a.yandex-team.ru/arcadia/extsearch/geo/kernel/common/coords.cpp?rev=r9700078#L179

        const double lon1 = Deg2Rad(lhs.Lon);
        const double lon2 = Deg2Rad(rhs.Lon);

        const double lat1 = Deg2Rad(lhs.Lat);
        const double lat2 = Deg2Rad(rhs.Lat);

        if (fabs(lat1 - lat2) < 1e-8 && fabs(lon1 - lon2) < 1e-8) {
            return 0;
        }

        double s = sin((lat1 + lat2) / 2);
        double m = NWGS84::R / (1.0 - NWGS84::_e2 * s * s);

        const double z = cos(lon2 - lon1);
        return NWGS84::_g * m * acos(((z + 1.0) * cos(lat1 - lat2) + (z - 1.0) * cos(lat1 + lat2)) * 0.5);
    }
}
