#pragma once

#include <travel/hotels/proto/geocounter_service/geocounter_service.pb.h>
#include "features_filtering.h"
#include "additional_filter.h"

namespace NTravel::NGeoCounter {
    class TFilterRegistry {
    public:
        explicit TFilterRegistry(TStringEncoder& stringEncoder);

        TFeature BuildFeature(const TString& id, const TVector<TString>& values) const;

        std::unique_ptr<TFilterBase> BuildFilterForPredefined(const NTravelProto::NFilters::THotelFilter& pbFilter) const;

        TVector<std::unique_ptr<TFilterBase>> BuildMultiFilter(const NTravelProto::NFilters::THotelFilter& pbFilter,
                                                               const TBookingRange& bookingRange,
                                                               const TAges& ages,
                                                               bool addOfferDataFilters,
                                                               bool addSimplePreFilters) const;
        std::unique_ptr<TFilterBase> BuildFilter(const NTravelProto::NFilters::THotelFilter& pbFilter,
                                                 const TBookingRange& bookingRange,
                                                 const TAges& ages) const;
        TAdditionalFilter BuildAdditionalFilter(const NTravelProto::NGeoCounter::TGetCountsRequest::TAdditionalFilter& pbAdditionalFilter,
                                                const TBookingRange& bookingRange,
                                                const TAges& ages) const;

    private:
        std::unique_ptr<TFilterBase> BuildFilterSimple(const NTravelProto::NFilters::THotelFilter& pbFilter,
                                                       const TBookingRange& bookingRange,
                                                       bool isPassingOnNoData) const;

        std::unique_ptr<TFilterByOfferBusData> BuildFilterByOfferData(const NTravelProto::NFilters::THotelFilter& pbFilter,
                                                                      const TBookingRange& bookingRange,
                                                                      const TAges& ages) const;

        TAdditionalFilter::EType ConvertAdditionalFilterTypeEnum(const NTravelProto::NGeoCounter::TGetCountsRequest::TAdditionalFilter::EType& type) const;
        TStringEncoder& StringEncoder_;
    };
}
