#include "filters_config_reader.h"

#include <library/cpp/logger/global/global.h>
#include <library/cpp/resource/resource.h>
#include <google/protobuf/text_format.h>

namespace NTravel::NGeoCounter {
    NTravelProto::NHotelFiltersConfig::TFilterInfoConfig TFiltersConfigReader::Read() const {
        auto data = NResource::Find(ResourceName);
        NTravelProto::NHotelFiltersConfig::TFilterInfoConfig filterConfig;

        google::protobuf::TextFormat::Parser parser;
        parser.AllowUnknownField(false);
        if (!parser.ParseFromString(data, &filterConfig)) {
            ythrow yexception() << "can't parse filters config from resource " << ResourceName;
        }

        return filterConfig;
    }
}
