#include "offercache_client.h"

#include <util/system/event.h>

namespace NTravel::NGeoCounter {
    TOfferCacheClient::TOfferCacheClient(const NTravelProto::NAppConfig::TConfigGrpcClient& offerCacheClientConfig)
        : OfferCacheClient_(offerCacheClientConfig)
    {
    }

    TOfferCacheClient::~TOfferCacheClient() {
        Stop();
    }

    void TOfferCacheClient::RegisterCounters(NMonitor::TCounterSource& source) {
        source.RegisterSource(&Counters_, "OfferCacheClient");
    }

    void TOfferCacheClient::Start() {
    }

    void TOfferCacheClient::Stop() {
        OfferCacheClient_.Shutdown();
    }

    NTravelProto::NOfferCache::NApi::TReadResp TOfferCacheClient::Read(const NTravelProto::NOfferCache::NApi::TReadReq& req, const TString& logPrefix) {
        INFO_LOG << "TOfferCacheClient(" << logPrefix << "): Sending request to offercache" << Endl;

        TAutoEvent finished;
        NTravelProto::NOfferCache::NApi::TReadResp result;

        OfferCacheClient_.Request<NTravelProto::NOfferCache::NApi::TReadReq, NTravelProto::NOfferCache::NApi::TReadResp, &NTravelProto::NOfferCacheGrpc::OfferCacheServiceV1::Stub::AsyncRead>
            (req, NGrpc::TClientMetadata(), [this, req, &finished, &result](const TString& grpcError, const TString& remoteFQDN, const NTravelProto::NOfferCache::NApi::TReadResp& resp) {
                if (grpcError) {
                    ERROR_LOG << "OfferCache read request has gRPC error: " << grpcError << Endl;
                    Counters_.NGrpcErrors.Inc();
                } else {
                    INFO_LOG << "OfferCache read request finished, remote FQDN " << remoteFQDN << Endl;
                    result.CopyFrom(resp);
                }
                finished.Signal();
            });

        finished.Wait();
        return result;
    }

    void TOfferCacheClient::TCounters::QueryCounters(NMonitor::TCounterTable* ct) const {
        ct->insert(MAKE_COUNTER_PAIR(NGrpcErrors));
    }
}