#pragma once

#include <travel/hotels/proto/offercache_grpc/offercache_service.grpc.pb.h>

#include <travel/hotels/lib/cpp/mon/counter.h>
#include <travel/hotels/lib/cpp/grpc/grpc_async_client.h>

namespace NTravel::NGeoCounter {
    class TOfferCacheClient {
    public:
        explicit TOfferCacheClient(const NTravelProto::NAppConfig::TConfigGrpcClient& offerCacheClientConfig);
        ~TOfferCacheClient();

        void RegisterCounters(NMonitor::TCounterSource& counters);

        void Start();
        void Stop();

        NTravelProto::NOfferCache::NApi::TReadResp Read(const NTravelProto::NOfferCache::NApi::TReadReq& req, const TString& logPrefix);

    private:
        struct TCounters : public NMonitor::TCounterSource {
            NMonitor::TDerivCounter NGrpcErrors;

            void QueryCounters(NMonitor::TCounterTable* ct) const override;
        };

        TCounters Counters_;

        using TOfferCacheGrpcClient = NGrpc::TAsyncClient<NTravelProto::NOfferCacheGrpc::OfferCacheServiceV1>;
        TOfferCacheGrpcClient OfferCacheClient_;
    };
}