#include "promo_service_client.h"

#include <travel/hotels/lib/cpp/protobuf/tools.h>

#include <util/system/event.h>

namespace NTravel::NGeoCounter {
    TPromoServiceClient::TPromoServiceClient(const NTravelProto::NAppConfig::TConfigGrpcClient& promoServiceClientConfig)
        : PromoServiceClient_(promoServiceClientConfig)
    {
    }

    TPromoServiceClient::~TPromoServiceClient() {
        Stop();
    }

    void TPromoServiceClient::RegisterCounters(NMonitor::TCounterSource& source) {
        source.RegisterSource(&Counters_, "PromoServiceClient");
    }

    void TPromoServiceClient::Start() {
    }

    void TPromoServiceClient::Stop() {
        PromoServiceClient_.Shutdown();
    }

    NTravelProto::NPromoService::TGetActivePromosRsp TPromoServiceClient::GetActivePromos(const NTravelProto::NPromoService::TGetActivePromosReq& req, const TString& logPrefix) {
        INFO_LOG << "TPromoServiceClient(" << logPrefix << "): Sending request to promo service" << Endl;

        TAutoEvent finished;
        NTravelProto::NPromoService::TGetActivePromosRsp result;

        PromoServiceClient_.Request<NTravelProto::NPromoService::TGetActivePromosReq, NTravelProto::NPromoService::TGetActivePromosRsp, &NTravelProto::NPromoService::PromoServiceV1::Stub::AsyncGetActivePromos>
            (req, NGrpc::TClientMetadata(), [this, req, &finished, &result](const TString& grpcError, const TString& remoteFQDN, const NTravelProto::NPromoService::TGetActivePromosRsp& resp) {
                if (grpcError) {
                    ERROR_LOG << "Promo service read request has gRPC error: " << grpcError << Endl;
                    Counters_.NGrpcErrors.Inc();
                } else {
                    INFO_LOG << "Promo service read request finished, remote FQDN " << remoteFQDN << Endl;
                    result.CopyFrom(resp);
                }
                finished.Signal();
            });

        finished.Wait();
        return result;
    }

    NTravelProto::NPromoService::TGetActivePromosRsp TPromoServiceClient::GetActivePromos(TInstant now, const TString& logPrefix) {
        NTravelProto::NPromoService::TGetActivePromosReq req;
        NTravel::NProtobuf::InstantToTimestamp(now, req.MutableNow());
        return GetActivePromos(req, logPrefix);
    }

    void TPromoServiceClient::TCounters::QueryCounters(NMonitor::TCounterTable* ct) const {
        ct->insert(MAKE_COUNTER_PAIR(NGrpcErrors));
    }
}
